#! /bin/env pytest
"""
Tests of the Python bindings for Hamlib

DO NOT EDIT this autogenerated file, run "make generate-pytests" instead
"""
import Hamlib

class TestClass:
    """A pytest class for Hamlib.Rot"""

    @classmethod
    def setup_class(cls):
        """Common initialization before calling test methods"""
        cls.actual_callables, cls.actual_properties = cls.generate_data(Hamlib.Rot)

    def test_callables(self):
        """Check that nothing was added or removed"""
        expected_callables = ['close',
'get_conf',
'get_ext_func',
'get_ext_level',
'get_ext_parm',
'get_func',
'get_info',
'get_level',
'get_parm',
'get_position',
'has_get_func',
'has_get_level',
'has_get_parm',
'has_set_func',
'has_set_level',
'has_set_parm',
'move',
'open',
'park',
'reset',
'set_conf',
'set_ext_func',
'set_ext_level',
'set_ext_parm',
'set_func',
'set_level',
'set_parm',
'set_position',
'stop',
'token_lookup']
        assert expected_callables == self.actual_callables

    def test_properties(self):
        """Check that nothing was added or removed"""
        expected_properties = ['caps',
'do_exception',
'error_status',
'rot',
'state',
'thisown']
        assert expected_properties == self.actual_properties

    @classmethod
    def generate_data(cls, the_object):
        """Extract callables and properties from the given object"""
        callables = []
        properties = []
        for method_or_property in dir(the_object):
            if not method_or_property.startswith("_"):
                if callable(getattr(the_object, method_or_property)):
                    callables.append(method_or_property)
                else:
                    properties.append(method_or_property)

        callables.sort()
        properties.sort()
        return callables, properties
