#! /bin/env pytest
"""
Tests of the Python bindings for Hamlib

DO NOT EDIT this autogenerated file, run "make generate-pytests" instead
"""
import Hamlib

class TestClass:
    """A pytest class for Hamlib"""

    @classmethod
    def setup_class(cls):
        """Common initialization before calling test methods"""
        cls.actual_callables, cls.actual_properties = cls.generate_data(Hamlib)

    def test_callables(self):
        """Check that nothing was added or removed"""
        expected_callables = ['Amp',
'Rig',
'Rot',
'add2debugmsgsave',
'amp_caps',
'amp_state',
'azimuth_long_path',
'cal_table',
'cal_table_float',
'cal_table_float_table',
'cal_table_table',
'chan_list',
'channel',
'channelArray',
'channel_cap',
'confparams',
'confparams_u',
'confparams_u_c',
'confparams_u_n',
'dec2dmmm',
'dec2dms',
'deferred_config_header',
'deferred_config_item',
'distance_long_path',
'dmmm2dec',
'dms2dec',
'ext_list',
'filter_list',
'freq_range_t',
'gran',
'hl_usleep',
'locator2longlat',
'longlat2locator',
'multicast_s',
'netrigctl_get_vfo_mode',
'qrb',
'rig_callbacks',
'rig_caps',
'rig_get_debug',
'rig_set_debug',
'rig_set_debug_time_stamp',
'rig_spectrum_avg_mode',
'rig_spectrum_line',
'rig_spectrum_scope',
'rig_state',
'rig_stragclevel',
'rig_strcommstatus',
'rig_strfunc',
'rig_strlevel',
'rig_strmtype',
'rig_strparm',
'rig_strptrshift',
'rig_strrmode',
'rig_strrmodes',
'rig_strscan',
'rig_strspectrummode',
'rig_strstatus',
'rig_strvfo',
'rig_strvfop',
'rigerror',
'rigerror2',
'rot_caps',
'rot_state',
'toneArray',
'tuning_step_list',
'value_t',
'value_t_b']
        assert expected_callables == self.actual_callables

    def test_properties(self):
        """Check that nothing was added or removed"""
        expected_properties = ['AMP_FLAG_1',
'AMP_FLAG_2',
'AMP_LEVEL_FAULT',
'AMP_LEVEL_NH',
'AMP_LEVEL_NONE',
'AMP_LEVEL_PF',
'AMP_LEVEL_PWR',
'AMP_LEVEL_PWR_FWD',
'AMP_LEVEL_PWR_INPUT',
'AMP_LEVEL_PWR_PEAK',
'AMP_LEVEL_PWR_REFLECTED',
'AMP_LEVEL_SWR',
'AMP_MODEL_DUMMY',
'AMP_MODEL_ELECRAFT_KPA1500',
'AMP_MODEL_EXPERT_FA',
'AMP_MODEL_GEMINI_DX1200',
'AMP_MODEL_NETAMPCTL',
'AMP_MODEL_NONE',
'AMP_RESET_AMP',
'AMP_RESET_FAULT',
'AMP_RESET_MEM',
'AMP_TYPE_OTHER',
'BUILTINFUNC',
'CTCSS_LIST_SIZE',
'DCS_LIST_SIZE',
'DEBUGMSGSAVE_SIZE',
'GPIO1',
'GPIO2',
'GPIO3',
'GPIO4',
'HAMLIB_CACHE_ALL',
'HAMLIB_CACHE_ALWAYS',
'HAMLIB_CACHE_FREQ',
'HAMLIB_CACHE_MODE',
'HAMLIB_CACHE_PTT',
'HAMLIB_CACHE_SPLIT',
'HAMLIB_CACHE_VFO',
'HAMLIB_CACHE_WIDTH',
'HAMLIB_CHANLSTSIZ',
'HAMLIB_CHECK_RIG_CAPS',
'HAMLIB_COOKIE_SIZE',
'HAMLIB_ELAPSED_GET',
'HAMLIB_ELAPSED_INVALIDATE',
'HAMLIB_ELAPSED_SET',
'HAMLIB_FILPATHLEN',
'HAMLIB_FLTLSTSIZ',
'HAMLIB_FRQRANGESIZ',
'HAMLIB_MAXCHANDESC',
'HAMLIB_MAXDBLSTSIZ',
'HAMLIB_MAX_AGC_LEVELS',
'HAMLIB_MAX_CAL_LENGTH',
'HAMLIB_MAX_MODES',
'HAMLIB_MAX_ROTORS',
'HAMLIB_MAX_RSCANS',
'HAMLIB_MAX_SNAPSHOT_PACKET_SIZE',
'HAMLIB_MAX_SPECTRUM_AVG_MODES',
'HAMLIB_MAX_SPECTRUM_DATA',
'HAMLIB_MAX_SPECTRUM_MODES',
'HAMLIB_MAX_SPECTRUM_SCOPES',
'HAMLIB_MAX_SPECTRUM_SPANS',
'HAMLIB_MAX_VFOS',
'HAMLIB_MAX_VFO_OPS',
'HAMLIB_RIGNAMSIZ',
'HAMLIB_RIGVERSIZ',
'HAMLIB_SECRET_LENGTH',
'HAMLIB_SETTINGS_FILE',
'HAMLIB_TSLSTSIZ',
'MAX_MODELS_PER_BACKEND',
'NETAMPCTL_RET',
'NETRIGCTL_RET',
'NETROTCTL_RET',
'RIG_AGC_AUTO',
'RIG_AGC_FAST',
'RIG_AGC_LAST',
'RIG_AGC_LONG',
'RIG_AGC_MEDIUM',
'RIG_AGC_NONE',
'RIG_AGC_OFF',
'RIG_AGC_ON',
'RIG_AGC_SLOW',
'RIG_AGC_SUPERFAST',
'RIG_AGC_USER',
'RIG_ANN_CW',
'RIG_ANN_ENG',
'RIG_ANN_FREQ',
'RIG_ANN_JAP',
'RIG_ANN_NONE',
'RIG_ANN_OFF',
'RIG_ANN_RXMODE',
'RIG_ANT_MAX',
'RIG_ANT_NONE',
'RIG_BANDSELECT_10M',
'RIG_BANDSELECT_12M',
'RIG_BANDSELECT_13CM',
'RIG_BANDSELECT_15M',
'RIG_BANDSELECT_160M',
'RIG_BANDSELECT_17M',
'RIG_BANDSELECT_1_25M',
'RIG_BANDSELECT_20M',
'RIG_BANDSELECT_2200M',
'RIG_BANDSELECT_23CM',
'RIG_BANDSELECT_2M',
'RIG_BANDSELECT_30M',
'RIG_BANDSELECT_33CM',
'RIG_BANDSELECT_3CM',
'RIG_BANDSELECT_40M',
'RIG_BANDSELECT_4M',
'RIG_BANDSELECT_5CM',
'RIG_BANDSELECT_600M',
'RIG_BANDSELECT_60M',
'RIG_BANDSELECT_6M',
'RIG_BANDSELECT_70CM',
'RIG_BANDSELECT_80M',
'RIG_BANDSELECT_9CM',
'RIG_BANDSELECT_AIR',
'RIG_BANDSELECT_GEN',
'RIG_BANDSELECT_MW',
'RIG_BANDSELECT_UNUSED',
'RIG_BANDSELECT_WFM',
'RIG_BAND_10M',
'RIG_BAND_12M',
'RIG_BAND_144MHZ',
'RIG_BAND_15M',
'RIG_BAND_160M',
'RIG_BAND_17M',
'RIG_BAND_20M',
'RIG_BAND_30M',
'RIG_BAND_40M',
'RIG_BAND_430MHZ',
'RIG_BAND_60M',
'RIG_BAND_6M',
'RIG_BAND_80M',
'RIG_BAND_AIR',
'RIG_BAND_GEN',
'RIG_BAND_MW',
'RIG_BAND_UNUSED',
'RIG_BUSBUSY',
'RIG_BUSERROR',
'RIG_CAPS_HAS_GET_LEVEL',
'RIG_CAPS_HAS_SET_LEVEL',
'RIG_CAPS_MFG_NAME_CPTR',
'RIG_CAPS_MODEL_NAME_CPTR',
'RIG_CAPS_PORT_TYPE',
'RIG_CAPS_PTT_TYPE',
'RIG_CAPS_RIG_MODEL',
'RIG_CAPS_STATUS_CPTR',
'RIG_CAPS_TARGETABLE_VFO',
'RIG_CAPS_VERSION_CPTR',
'RIG_CHFLAG_DATA',
'RIG_CHFLAG_NONE',
'RIG_CHFLAG_PSKIP',
'RIG_CHFLAG_SKIP',
'RIG_CLIENT_GPREDICT',
'RIG_CLIENT_UNKNOWN',
'RIG_CLIENT_WSJTX',
'RIG_COMM_STATUS_CONNECTING',
'RIG_COMM_STATUS_DISCONNECTED',
'RIG_COMM_STATUS_ERROR',
'RIG_COMM_STATUS_OK',
'RIG_COMM_STATUS_TERMINATED',
'RIG_COMM_STATUS_WARNING',
'RIG_CONF_BINARY',
'RIG_CONF_BUTTON',
'RIG_CONF_CHECKBUTTON',
'RIG_CONF_COMBO',
'RIG_CONF_END',
'RIG_CONF_INT',
'RIG_CONF_NUMERIC',
'RIG_CONF_STRING',
'RIG_COOKIE_GET',
'RIG_COOKIE_RELEASE',
'RIG_COOKIE_RENEW',
'RIG_DCD_CM108',
'RIG_DCD_GPIO',
'RIG_DCD_GPION',
'RIG_DCD_NONE',
'RIG_DCD_OFF',
'RIG_DCD_ON',
'RIG_DCD_PARALLEL',
'RIG_DCD_RIG',
'RIG_DCD_SERIAL_CAR',
'RIG_DCD_SERIAL_CTS',
'RIG_DCD_SERIAL_DSR',
'RIG_DEBUG_BUG',
'RIG_DEBUG_CACHE',
'RIG_DEBUG_ERR',
'RIG_DEBUG_NONE',
'RIG_DEBUG_TRACE',
'RIG_DEBUG_VERBOSE',
'RIG_DEBUG_WARN',
'RIG_EACCESS',
'RIG_EARG',
'RIG_ECONF',
'RIG_EDEPRECATED',
'RIG_EDOM',
'RIG_EEND',
'RIG_EINTERNAL',
'RIG_EINVAL',
'RIG_EIO',
'RIG_ELIMIT',
'RIG_ENAVAIL',
'RIG_ENIMPL',
'RIG_ENOMEM',
'RIG_ENTARGET',
'RIG_EPOWER',
'RIG_EPROTO',
'RIG_ERJCTED',
'RIG_ESECURITY',
'RIG_ETIMEOUT',
'RIG_ETRUNC',
'RIG_EVFO',
'RIG_FLAG_APRS',
'RIG_FLAG_COMPUTER',
'RIG_FLAG_DXCLUSTER',
'RIG_FLAG_HANDHELD',
'RIG_FLAG_MOBILE',
'RIG_FLAG_RECEIVER',
'RIG_FLAG_SCANNER',
'RIG_FLAG_TNC',
'RIG_FLAG_TRANSMITTER',
'RIG_FLAG_TRUNKING',
'RIG_FLAG_TUNER',
'RIG_FLT_ANY',
'RIG_FUNCTION_CLEANUP',
'RIG_FUNCTION_CLOSE',
'RIG_FUNCTION_DECODE_EVENT',
'RIG_FUNCTION_GET_ANT',
'RIG_FUNCTION_GET_CHANNEL',
'RIG_FUNCTION_GET_CHAN_ALL_CB',
'RIG_FUNCTION_GET_CONF',
'RIG_FUNCTION_GET_CONF2',
'RIG_FUNCTION_GET_CTCSS_SQL',
'RIG_FUNCTION_GET_CTCSS_TONE',
'RIG_FUNCTION_GET_DCD',
'RIG_FUNCTION_GET_DCS_CODE',
'RIG_FUNCTION_GET_DCS_SQL',
'RIG_FUNCTION_GET_EXT_FUNC',
'RIG_FUNCTION_GET_EXT_LEVEL',
'RIG_FUNCTION_GET_EXT_PARM',
'RIG_FUNCTION_GET_FREQ',
'RIG_FUNCTION_GET_FUNC',
'RIG_FUNCTION_GET_INFO',
'RIG_FUNCTION_GET_LEVEL',
'RIG_FUNCTION_GET_MEM',
'RIG_FUNCTION_GET_MEM_ALL_CB',
'RIG_FUNCTION_GET_MODE',
'RIG_FUNCTION_GET_PARM',
'RIG_FUNCTION_GET_POWERSTAT',
'RIG_FUNCTION_GET_PTT',
'RIG_FUNCTION_GET_RIT',
'RIG_FUNCTION_GET_RPTR_OFFS',
'RIG_FUNCTION_GET_RPTR_SHIFT',
'RIG_FUNCTION_GET_SPLIT_FREQ',
'RIG_FUNCTION_GET_SPLIT_FREQ_MODE',
'RIG_FUNCTION_GET_SPLIT_VFO',
'RIG_FUNCTION_GET_TONE',
'RIG_FUNCTION_GET_TONE_SQL',
'RIG_FUNCTION_GET_TRN',
'RIG_FUNCTION_GET_TS',
'RIG_FUNCTION_GET_VFO',
'RIG_FUNCTION_GET_XIT',
'RIG_FUNCTION_INIT',
'RIG_FUNCTION_IS_ASYNC_FRAME',
'RIG_FUNCTION_MW2POWER',
'RIG_FUNCTION_OPEN',
'RIG_FUNCTION_POWER2MW',
'RIG_FUNCTION_PROCESS_ASYNC_FRAME',
'RIG_FUNCTION_READ_FRAME_DIRECT',
'RIG_FUNCTION_RESET',
'RIG_FUNCTION_SCAN',
'RIG_FUNCTION_SEND_DTMF',
'RIG_FUNCTION_SEND_MORSE',
'RIG_FUNCTION_SEND_VOICE_MEM',
'RIG_FUNCTION_SET_ANT',
'RIG_FUNCTION_SET_BANK',
'RIG_FUNCTION_SET_CHANNEL',
'RIG_FUNCTION_SET_CHAN_ALL_CB',
'RIG_FUNCTION_SET_CONF',
'RIG_FUNCTION_SET_CTCSS_SQL',
'RIG_FUNCTION_SET_CTCSS_TONE',
'RIG_FUNCTION_SET_DCS_CODE',
'RIG_FUNCTION_SET_DCS_SQL',
'RIG_FUNCTION_SET_EXT_FUNC',
'RIG_FUNCTION_SET_EXT_LEVEL',
'RIG_FUNCTION_SET_EXT_PARM',
'RIG_FUNCTION_SET_FREQ',
'RIG_FUNCTION_SET_FUNC',
'RIG_FUNCTION_SET_LEVEL',
'RIG_FUNCTION_SET_MEM',
'RIG_FUNCTION_SET_MEM_ALL_CB',
'RIG_FUNCTION_SET_MODE',
'RIG_FUNCTION_SET_PARM',
'RIG_FUNCTION_SET_POWERSTAT',
'RIG_FUNCTION_SET_PTT',
'RIG_FUNCTION_SET_RIT',
'RIG_FUNCTION_SET_RPTR_OFFS',
'RIG_FUNCTION_SET_RPTR_SHIFT',
'RIG_FUNCTION_SET_SPLIT_FREQ',
'RIG_FUNCTION_SET_SPLIT_FREQ_MODE',
'RIG_FUNCTION_SET_SPLIT_MODE',
'RIG_FUNCTION_SET_SPLIT_VFO',
'RIG_FUNCTION_SET_TONE',
'RIG_FUNCTION_SET_TONE_SQL',
'RIG_FUNCTION_SET_TRN',
'RIG_FUNCTION_SET_TS',
'RIG_FUNCTION_SET_VFO',
'RIG_FUNCTION_SET_VFO_OPT',
'RIG_FUNCTION_SET_XIT',
'RIG_FUNCTION_STOP_MORSE',
'RIG_FUNCTION_STOP_VOICE_MEM',
'RIG_FUNCTION_VFO_OP',
'RIG_FUNCTION_WAIT_MORSE',
'RIG_FUNC_ABM',
'RIG_FUNC_AFC',
'RIG_FUNC_AFLT',
'RIG_FUNC_AIP',
'RIG_FUNC_ANF',
'RIG_FUNC_ANL',
'RIG_FUNC_APF',
'RIG_FUNC_ARO',
'RIG_FUNC_BC',
'RIG_FUNC_BC2',
'RIG_FUNC_BIT49',
'RIG_FUNC_BIT50',
'RIG_FUNC_BIT51',
'RIG_FUNC_BIT52',
'RIG_FUNC_BIT53',
'RIG_FUNC_BIT54',
'RIG_FUNC_BIT55',
'RIG_FUNC_BIT56',
'RIG_FUNC_BIT57',
'RIG_FUNC_BIT58',
'RIG_FUNC_BIT59',
'RIG_FUNC_BIT60',
'RIG_FUNC_BIT61',
'RIG_FUNC_BIT62',
'RIG_FUNC_BIT63',
'RIG_FUNC_COMP',
'RIG_FUNC_CSQL',
'RIG_FUNC_DIVERSITY',
'RIG_FUNC_DSQL',
'RIG_FUNC_DUAL_WATCH',
'RIG_FUNC_FAGC',
'RIG_FUNC_FBKIN',
'RIG_FUNC_LOCK',
'RIG_FUNC_MBC',
'RIG_FUNC_MN',
'RIG_FUNC_MON',
'RIG_FUNC_MUTE',
'RIG_FUNC_NB',
'RIG_FUNC_NB2',
'RIG_FUNC_NONE',
'RIG_FUNC_NR',
'RIG_FUNC_OVF_STATUS',
'RIG_FUNC_RESUME',
'RIG_FUNC_REV',
'RIG_FUNC_RF',
'RIG_FUNC_RIT',
'RIG_FUNC_SATMODE',
'RIG_FUNC_SBKIN',
'RIG_FUNC_SCEN',
'RIG_FUNC_SCOPE',
'RIG_FUNC_SEND_MORSE',
'RIG_FUNC_SEND_VOICE_MEM',
'RIG_FUNC_SLICE',
'RIG_FUNC_SPECTRUM',
'RIG_FUNC_SPECTRUM_HOLD',
'RIG_FUNC_SQL',
'RIG_FUNC_SYNC',
'RIG_FUNC_TBURST',
'RIG_FUNC_TONE',
'RIG_FUNC_TRANSCEIVE',
'RIG_FUNC_TSQL',
'RIG_FUNC_TUNER',
'RIG_FUNC_VOX',
'RIG_FUNC_VSC',
'RIG_FUNC_XIT',
'RIG_HANDSHAKE_HARDWARE',
'RIG_HANDSHAKE_NONE',
'RIG_HANDSHAKE_XONXOFF',
'RIG_KEYERTYPE_BUG',
'RIG_KEYERTYPE_PADDLE',
'RIG_KEYERTYPE_STRAIGHT',
'RIG_KEYERTYPE_UNKNOWN',
'RIG_LEVEL_53',
'RIG_LEVEL_54',
'RIG_LEVEL_55',
'RIG_LEVEL_56',
'RIG_LEVEL_57',
'RIG_LEVEL_58',
'RIG_LEVEL_59',
'RIG_LEVEL_60',
'RIG_LEVEL_61',
'RIG_LEVEL_62',
'RIG_LEVEL_63',
'RIG_LEVEL_AF',
'RIG_LEVEL_AGC',
'RIG_LEVEL_AGC_TIME',
'RIG_LEVEL_ALC',
'RIG_LEVEL_ANTIVOX',
'RIG_LEVEL_APF',
'RIG_LEVEL_ATT',
'RIG_LEVEL_BALANCE',
'RIG_LEVEL_BAND_SELECT',
'RIG_LEVEL_BKINDL',
'RIG_LEVEL_BKIN_DLYMS',
'RIG_LEVEL_COMP',
'RIG_LEVEL_COMP_METER',
'RIG_LEVEL_CWPITCH',
'RIG_LEVEL_FLOAT_LIST',
'RIG_LEVEL_ID_METER',
'RIG_LEVEL_IF',
'RIG_LEVEL_KEYSPD',
'RIG_LEVEL_METER',
'RIG_LEVEL_MICGAIN',
'RIG_LEVEL_MONITOR_GAIN',
'RIG_LEVEL_NB',
'RIG_LEVEL_NONE',
'RIG_LEVEL_NOTCHF',
'RIG_LEVEL_NOTCHF_RAW',
'RIG_LEVEL_NR',
'RIG_LEVEL_PBT_IN',
'RIG_LEVEL_PBT_OUT',
'RIG_LEVEL_PREAMP',
'RIG_LEVEL_RAWSTR',
'RIG_LEVEL_READONLY_LIST',
'RIG_LEVEL_RF',
'RIG_LEVEL_RFPOWER',
'RIG_LEVEL_RFPOWER_METER',
'RIG_LEVEL_RFPOWER_METER_WATTS',
'RIG_LEVEL_SLOPE_HIGH',
'RIG_LEVEL_SLOPE_LOW',
'RIG_LEVEL_SPECTRUM_ATT',
'RIG_LEVEL_SPECTRUM_AVG',
'RIG_LEVEL_SPECTRUM_EDGE_HIGH',
'RIG_LEVEL_SPECTRUM_EDGE_LOW',
'RIG_LEVEL_SPECTRUM_MODE',
'RIG_LEVEL_SPECTRUM_REF',
'RIG_LEVEL_SPECTRUM_SPAN',
'RIG_LEVEL_SPECTRUM_SPEED',
'RIG_LEVEL_SQL',
'RIG_LEVEL_STRENGTH',
'RIG_LEVEL_SWR',
'RIG_LEVEL_TEMP_METER',
'RIG_LEVEL_USB_AF',
'RIG_LEVEL_USB_AF_INPUT',
'RIG_LEVEL_VD_METER',
'RIG_LEVEL_VOXDELAY',
'RIG_LEVEL_VOXGAIN',
'RIG_MEM_CAPS_ALL',
'RIG_METER_ALC',
'RIG_METER_COMP',
'RIG_METER_DB',
'RIG_METER_IC',
'RIG_METER_NONE',
'RIG_METER_PO',
'RIG_METER_SWR',
'RIG_METER_TEMP',
'RIG_METER_VDD',
'RIG_MODEL_505DSP',
'RIG_MODEL_ACLOG',
'RIG_MODEL_ADT_200A',
'RIG_MODEL_AR16',
'RIG_MODEL_AR2500',
'RIG_MODEL_AR2700',
'RIG_MODEL_AR3000',
'RIG_MODEL_AR3000A',
'RIG_MODEL_AR3030',
'RIG_MODEL_AR5000',
'RIG_MODEL_AR5000A',
'RIG_MODEL_AR7030',
'RIG_MODEL_AR7030P',
'RIG_MODEL_AR8000',
'RIG_MODEL_AR8200',
'RIG_MODEL_AR8600',
'RIG_MODEL_ARMSTRONG',
'RIG_MODEL_ATD578UVIII',
'RIG_MODEL_BARRETT_2050',
'RIG_MODEL_BARRETT_4050',
'RIG_MODEL_BARRETT_4100',
'RIG_MODEL_BARRETT_950',
'RIG_MODEL_BC235',
'RIG_MODEL_BC245',
'RIG_MODEL_BC250',
'RIG_MODEL_BC780',
'RIG_MODEL_BC785',
'RIG_MODEL_BC786',
'RIG_MODEL_BC895',
'RIG_MODEL_BC898',
'RIG_MODEL_BCD396T',
'RIG_MODEL_BCD996T',
'RIG_MODEL_BCT8',
'RIG_MODEL_CMH530',
'RIG_MODEL_CODAN_2110',
'RIG_MODEL_CODAN_ENVOY',
'RIG_MODEL_CODAN_NGT',
'RIG_MODEL_CTX10',
'RIG_MODEL_DDS60',
'RIG_MODEL_DELTAII',
'RIG_MODEL_DKR8',
'RIG_MODEL_DKR8A',
'RIG_MODEL_DKR8B',
'RIG_MODEL_DORJI_DRA818U',
'RIG_MODEL_DORJI_DRA818V',
'RIG_MODEL_DRT1',
'RIG_MODEL_DSP10',
'RIG_MODEL_DTTSP',
'RIG_MODEL_DTTSP_UDP',
'RIG_MODEL_DUMMY',
'RIG_MODEL_DUMMY_NOVFO',
'RIG_MODEL_DWT',
'RIG_MODEL_DX77',
'RIG_MODEL_DXSR8',
'RIG_MODEL_EB200',
'RIG_MODEL_EK070',
'RIG_MODEL_EK890',
'RIG_MODEL_EK891',
'RIG_MODEL_EK895',
'RIG_MODEL_EK89X',
'RIG_MODEL_EKD500',
'RIG_MODEL_ELAD_FDM_DUO',
'RIG_MODEL_ELEKTOR304',
'RIG_MODEL_ELEKTOR507',
'RIG_MODEL_ESM500',
'RIG_MODEL_ESMC',
'RIG_MODEL_F6K',
'RIG_MODEL_FASDR',
'RIG_MODEL_FIFISDR',
'RIG_MODEL_FLRIG',
'RIG_MODEL_FRG100',
'RIG_MODEL_FRG8800',
'RIG_MODEL_FRG9600',
'RIG_MODEL_FT100',
'RIG_MODEL_FT1000',
'RIG_MODEL_FT1000D',
'RIG_MODEL_FT1000MP',
'RIG_MODEL_FT1000MPMKV',
'RIG_MODEL_FT1000MPMKVFLD',
'RIG_MODEL_FT2000',
'RIG_MODEL_FT450',
'RIG_MODEL_FT450D',
'RIG_MODEL_FT575',
'RIG_MODEL_FT600',
'RIG_MODEL_FT650',
'RIG_MODEL_FT710',
'RIG_MODEL_FT736R',
'RIG_MODEL_FT747',
'RIG_MODEL_FT757',
'RIG_MODEL_FT757GXII',
'RIG_MODEL_FT767',
'RIG_MODEL_FT817',
'RIG_MODEL_FT818',
'RIG_MODEL_FT820',
'RIG_MODEL_FT840',
'RIG_MODEL_FT847',
'RIG_MODEL_FT847UNI',
'RIG_MODEL_FT857',
'RIG_MODEL_FT890',
'RIG_MODEL_FT891',
'RIG_MODEL_FT897',
'RIG_MODEL_FT897D',
'RIG_MODEL_FT900',
'RIG_MODEL_FT9000',
'RIG_MODEL_FT9000OLD',
'RIG_MODEL_FT920',
'RIG_MODEL_FT950',
'RIG_MODEL_FT980',
'RIG_MODEL_FT990',
'RIG_MODEL_FT990UNI',
'RIG_MODEL_FT991',
'RIG_MODEL_FTDX10',
'RIG_MODEL_FTDX101D',
'RIG_MODEL_FTDX101MP',
'RIG_MODEL_FTDX1200',
'RIG_MODEL_FTDX3000',
'RIG_MODEL_FTDX5000',
'RIG_MODEL_FTX1',
'RIG_MODEL_FUNCUBEDONGLE',
'RIG_MODEL_FUNCUBEDONGLEPLUS',
'RIG_MODEL_FX4',
'RIG_MODEL_G303',
'RIG_MODEL_G305',
'RIG_MODEL_G313',
'RIG_MODEL_G315',
'RIG_MODEL_G90',
'RIG_MODEL_GNURADIO',
'RIG_MODEL_GQRX',
'RIG_MODEL_GRAUDIO',
'RIG_MODEL_GRAUDIOIQ',
'RIG_MODEL_GS100',
'RIG_MODEL_HF1000',
'RIG_MODEL_HF1000A',
'RIG_MODEL_HF150',
'RIG_MODEL_HF225',
'RIG_MODEL_HF235',
'RIG_MODEL_HF250',
'RIG_MODEL_HIQSDR',
'RIG_MODEL_HPSDR',
'RIG_MODEL_IC1271',
'RIG_MODEL_IC1275',
'RIG_MODEL_IC271',
'RIG_MODEL_IC2730',
'RIG_MODEL_IC275',
'RIG_MODEL_IC375',
'RIG_MODEL_IC471',
'RIG_MODEL_IC475',
'RIG_MODEL_IC575',
'RIG_MODEL_IC7000',
'RIG_MODEL_IC703',
'RIG_MODEL_IC705',
'RIG_MODEL_IC706',
'RIG_MODEL_IC706MKII',
'RIG_MODEL_IC706MKIIG',
'RIG_MODEL_IC707',
'RIG_MODEL_IC7100',
'RIG_MODEL_IC718',
'RIG_MODEL_IC7200',
'RIG_MODEL_IC725',
'RIG_MODEL_IC726',
'RIG_MODEL_IC728',
'RIG_MODEL_IC729',
'RIG_MODEL_IC7300',
'RIG_MODEL_IC731',
'RIG_MODEL_IC735',
'RIG_MODEL_IC736',
'RIG_MODEL_IC737',
'RIG_MODEL_IC738',
'RIG_MODEL_IC7410',
'RIG_MODEL_IC746',
'RIG_MODEL_IC746PRO',
'RIG_MODEL_IC751',
'RIG_MODEL_IC751A',
'RIG_MODEL_IC756',
'RIG_MODEL_IC756PRO',
'RIG_MODEL_IC756PROII',
'RIG_MODEL_IC756PROIII',
'RIG_MODEL_IC7600',
'RIG_MODEL_IC761',
'RIG_MODEL_IC7610',
'RIG_MODEL_IC765',
'RIG_MODEL_IC7700',
'RIG_MODEL_IC775',
'RIG_MODEL_IC7760',
'RIG_MODEL_IC78',
'RIG_MODEL_IC7800',
'RIG_MODEL_IC781',
'RIG_MODEL_IC785x',
'RIG_MODEL_IC820',
'RIG_MODEL_IC821H',
'RIG_MODEL_IC905',
'RIG_MODEL_IC910',
'RIG_MODEL_IC9100',
'RIG_MODEL_IC92D',
'RIG_MODEL_IC970',
'RIG_MODEL_IC9700',
'RIG_MODEL_ICF8101',
'RIG_MODEL_ICID1',
'RIG_MODEL_ICR10',
'RIG_MODEL_ICR20',
'RIG_MODEL_ICR30',
'RIG_MODEL_ICR6',
'RIG_MODEL_ICR7000',
'RIG_MODEL_ICR71',
'RIG_MODEL_ICR7100',
'RIG_MODEL_ICR72',
'RIG_MODEL_ICR75',
'RIG_MODEL_ICR8500',
'RIG_MODEL_ICR8600',
'RIG_MODEL_ICR9000',
'RIG_MODEL_ICR9500',
'RIG_MODEL_ICRX7',
'RIG_MODEL_IC_M700PRO',
'RIG_MODEL_IC_M710',
'RIG_MODEL_IC_M802',
'RIG_MODEL_IC_M803',
'RIG_MODEL_ID31',
'RIG_MODEL_ID4100',
'RIG_MODEL_ID51',
'RIG_MODEL_ID5100',
'RIG_MODEL_ID52PLUS',
'RIG_MODEL_JST145',
'RIG_MODEL_JST245',
'RIG_MODEL_K2',
'RIG_MODEL_K3',
'RIG_MODEL_K3S',
'RIG_MODEL_K4',
'RIG_MODEL_KX2',
'RIG_MODEL_KX3',
'RIG_MODEL_LAB599_TX500',
'RIG_MODEL_MALACHITE',
'RIG_MODEL_MC4020',
'RIG_MODEL_MCHFQRP',
'RIG_MODEL_MDS4710',
'RIG_MODEL_MDS9710',
'RIG_MODEL_MICOM2',
'RIG_MODEL_MICROTUNE_4702',
'RIG_MODEL_MICROTUNE_4707',
'RIG_MODEL_MICROTUNE_4937',
'RIG_MODEL_MINISCOUT',
'RIG_MODEL_MINIVNA',
'RIG_MODEL_NETRIGCTL',
'RIG_MODEL_NONE',
'RIG_MODEL_NRD345',
'RIG_MODEL_NRD525',
'RIG_MODEL_NRD535',
'RIG_MODEL_NRD545',
'RIG_MODEL_OMNIVI',
'RIG_MODEL_OMNIVIP',
'RIG_MODEL_OS456',
'RIG_MODEL_OS535',
'RIG_MODEL_PARAGON2',
'RIG_MODEL_PCR100',
'RIG_MODEL_PCR1000',
'RIG_MODEL_PCR1500',
'RIG_MODEL_PCR2500',
'RIG_MODEL_PERSEUS',
'RIG_MODEL_PMR171',
'RIG_MODEL_PMSDR',
'RIG_MODEL_POWERSDR',
'RIG_MODEL_PRM8060',
'RIG_MODEL_PRM8070',
'RIG_MODEL_PRO2052',
'RIG_MODEL_PT8000A',
'RIG_MODEL_Q900',
'RIG_MODEL_QRPLABS',
'RIG_MODEL_QRPLABS_QMX',
'RIG_MODEL_QUISK',
'RIG_MODEL_R5000',
'RIG_MODEL_RA3702',
'RIG_MODEL_RA3710',
'RIG_MODEL_RA3720',
'RIG_MODEL_RA3790',
'RIG_MODEL_RA6790',
'RIG_MODEL_RS2005',
'RIG_MODEL_RS2006',
'RIG_MODEL_RS2035',
'RIG_MODEL_RS2041',
'RIG_MODEL_RS2042',
'RIG_MODEL_RS64',
'RIG_MODEL_RSHFIQ',
'RIG_MODEL_RX320',
'RIG_MODEL_RX331',
'RIG_MODEL_RX340',
'RIG_MODEL_RX350',
'RIG_MODEL_SDR1000',
'RIG_MODEL_SDR1000RFE',
'RIG_MODEL_SDRCONSOLE',
'RIG_MODEL_SDRSHARP',
'RIG_MODEL_SDRUNO',
'RIG_MODEL_SDU5000',
'RIG_MODEL_SDU5500',
'RIG_MODEL_SI570AVRUSB',
'RIG_MODEL_SI570PEABERRY1',
'RIG_MODEL_SI570PEABERRY2',
'RIG_MODEL_SI570PICUSB',
'RIG_MODEL_SMARTSDR_A',
'RIG_MODEL_SMARTSDR_B',
'RIG_MODEL_SMARTSDR_C',
'RIG_MODEL_SMARTSDR_D',
'RIG_MODEL_SMARTSDR_E',
'RIG_MODEL_SMARTSDR_F',
'RIG_MODEL_SMARTSDR_G',
'RIG_MODEL_SMARTSDR_H',
'RIG_MODEL_SR2200',
'RIG_MODEL_TCI1X',
'RIG_MODEL_THD72A',
'RIG_MODEL_THD74',
'RIG_MODEL_THD7A',
'RIG_MODEL_THD7AG',
'RIG_MODEL_THETIS',
'RIG_MODEL_THF6A',
'RIG_MODEL_THF7E',
'RIG_MODEL_THG71',
'RIG_MODEL_TMD700',
'RIG_MODEL_TMD710',
'RIG_MODEL_TMV7',
'RIG_MODEL_TMV71',
'RIG_MODEL_TRANSFOX',
'RIG_MODEL_TRC80',
'RIG_MODEL_TRP7000',
'RIG_MODEL_TRP8000',
'RIG_MODEL_TRP8255',
'RIG_MODEL_TRP9000',
'RIG_MODEL_TRUSDX',
'RIG_MODEL_TRXMANAGER_RIG',
'RIG_MODEL_TS140S',
'RIG_MODEL_TS2000',
'RIG_MODEL_TS440',
'RIG_MODEL_TS450S',
'RIG_MODEL_TS480',
'RIG_MODEL_TS50',
'RIG_MODEL_TS570D',
'RIG_MODEL_TS570S',
'RIG_MODEL_TS590S',
'RIG_MODEL_TS590SG',
'RIG_MODEL_TS680S',
'RIG_MODEL_TS690S',
'RIG_MODEL_TS711',
'RIG_MODEL_TS790',
'RIG_MODEL_TS811',
'RIG_MODEL_TS850',
'RIG_MODEL_TS870S',
'RIG_MODEL_TS890S',
'RIG_MODEL_TS930',
'RIG_MODEL_TS940',
'RIG_MODEL_TS950S',
'RIG_MODEL_TS950SDX',
'RIG_MODEL_TS990S',
'RIG_MODEL_TT516',
'RIG_MODEL_TT526',
'RIG_MODEL_TT538',
'RIG_MODEL_TT550',
'RIG_MODEL_TT565',
'RIG_MODEL_TT585',
'RIG_MODEL_TT588',
'RIG_MODEL_TT599',
'RIG_MODEL_USRP',
'RIG_MODEL_USRP0',
'RIG_MODEL_USRP_G',
'RIG_MODEL_V4L',
'RIG_MODEL_V4L2',
'RIG_MODEL_VR5000',
'RIG_MODEL_VX1700',
'RIG_MODEL_WJ8711',
'RIG_MODEL_WJ8888',
'RIG_MODEL_WR1000',
'RIG_MODEL_WR1500',
'RIG_MODEL_WR1550',
'RIG_MODEL_WR3100',
'RIG_MODEL_WR3150',
'RIG_MODEL_WR3500',
'RIG_MODEL_WR3700',
'RIG_MODEL_X108G',
'RIG_MODEL_X5105',
'RIG_MODEL_X6100',
'RIG_MODEL_X6200',
'RIG_MODEL_XG3',
'RIG_MODEL_XK2100',
'RIG_MODEL_XK852',
'RIG_MODEL_XPLORER',
'RIG_MODE_ALL',
'RIG_MODE_AM',
'RIG_MODE_AMN',
'RIG_MODE_AMS',
'RIG_MODE_BIT47',
'RIG_MODE_BIT48',
'RIG_MODE_BIT49',
'RIG_MODE_BIT50',
'RIG_MODE_BIT51',
'RIG_MODE_BIT52',
'RIG_MODE_BIT53',
'RIG_MODE_BIT54',
'RIG_MODE_BIT55',
'RIG_MODE_BIT56',
'RIG_MODE_BIT57',
'RIG_MODE_BIT58',
'RIG_MODE_BIT59',
'RIG_MODE_BIT60',
'RIG_MODE_BIT61',
'RIG_MODE_BIT62',
'RIG_MODE_C4FM',
'RIG_MODE_CW',
'RIG_MODE_CWN',
'RIG_MODE_CWR',
'RIG_MODE_DCR',
'RIG_MODE_DD',
'RIG_MODE_DPMR',
'RIG_MODE_DSB',
'RIG_MODE_DSTAR',
'RIG_MODE_ECSS',
'RIG_MODE_ECSSLSB',
'RIG_MODE_ECSSUSB',
'RIG_MODE_FAX',
'RIG_MODE_FM',
'RIG_MODE_FMN',
'RIG_MODE_IQ',
'RIG_MODE_ISBLSB',
'RIG_MODE_ISBUSB',
'RIG_MODE_LSB',
'RIG_MODE_LSBD1',
'RIG_MODE_LSBD2',
'RIG_MODE_LSBD3',
'RIG_MODE_NONE',
'RIG_MODE_NXDNVN',
'RIG_MODE_NXDN_N',
'RIG_MODE_P25',
'RIG_MODE_PKTAM',
'RIG_MODE_PKTFM',
'RIG_MODE_PKTFMN',
'RIG_MODE_PKTLSB',
'RIG_MODE_PKTSSB',
'RIG_MODE_PKTUSB',
'RIG_MODE_PSK',
'RIG_MODE_PSKR',
'RIG_MODE_RTTY',
'RIG_MODE_RTTYR',
'RIG_MODE_SAH',
'RIG_MODE_SAL',
'RIG_MODE_SAM',
'RIG_MODE_SPEC',
'RIG_MODE_SSB',
'RIG_MODE_TESTS_MAX',
'RIG_MODE_USB',
'RIG_MODE_USBD1',
'RIG_MODE_USBD2',
'RIG_MODE_USBD3',
'RIG_MODE_WFM',
'RIG_MODE_WFMS',
'RIG_MTYPE_BAND',
'RIG_MTYPE_CALL',
'RIG_MTYPE_EDGE',
'RIG_MTYPE_MEM',
'RIG_MTYPE_MEMOPAD',
'RIG_MTYPE_MORSE',
'RIG_MTYPE_NONE',
'RIG_MTYPE_PRIO',
'RIG_MTYPE_SAT',
'RIG_MTYPE_SPLIT',
'RIG_MTYPE_VOICE',
'RIG_MULTICAST_POLL',
'RIG_MULTICAST_SPECTRUM',
'RIG_MULTICAST_TRANSCEIVE',
'RIG_OK',
'RIG_OP_BAND_DOWN',
'RIG_OP_BAND_UP',
'RIG_OP_CPY',
'RIG_OP_DOWN',
'RIG_OP_FROM_VFO',
'RIG_OP_LEFT',
'RIG_OP_MCL',
'RIG_OP_NONE',
'RIG_OP_RIGHT',
'RIG_OP_TOGGLE',
'RIG_OP_TO_VFO',
'RIG_OP_TUNE',
'RIG_OP_UP',
'RIG_OP_XCHG',
'RIG_PARITY_EVEN',
'RIG_PARITY_MARK',
'RIG_PARITY_NONE',
'RIG_PARITY_ODD',
'RIG_PARITY_SPACE',
'RIG_PARM_AFIF',
'RIG_PARM_AFIF_ACC',
'RIG_PARM_AFIF_LAN',
'RIG_PARM_AFIF_WLAN',
'RIG_PARM_ANN',
'RIG_PARM_APO',
'RIG_PARM_BACKLIGHT',
'RIG_PARM_BANDSELECT',
'RIG_PARM_BAT',
'RIG_PARM_BEEP',
'RIG_PARM_KEYERTYPE',
'RIG_PARM_KEYLIGHT',
'RIG_PARM_NONE',
'RIG_PARM_SCREENSAVER',
'RIG_PARM_TIME',
'RIG_PORT_CM108',
'RIG_PORT_DEVICE',
'RIG_PORT_DTMF',
'RIG_PORT_GPIO',
'RIG_PORT_GPION',
'RIG_PORT_NETWORK',
'RIG_PORT_NONE',
'RIG_PORT_PACKET',
'RIG_PORT_PARALLEL',
'RIG_PORT_RPC',
'RIG_PORT_SERIAL',
'RIG_PORT_UDP_NETWORK',
'RIG_PORT_ULTRA',
'RIG_PORT_USB',
'RIG_POWER_OFF',
'RIG_POWER_ON',
'RIG_POWER_OPERATE',
'RIG_POWER_STANDBY',
'RIG_POWER_UNKNOWN',
'RIG_PTRX_AMPPORT',
'RIG_PTRX_AMPSTATE',
'RIG_PTRX_CACHE',
'RIG_PTRX_DCDPORT',
'RIG_PTRX_MAXIMUM',
'RIG_PTRX_NONE',
'RIG_PTRX_PTTPORT',
'RIG_PTRX_RIGPORT',
'RIG_PTRX_ROTPORT',
'RIG_PTRX_ROTPORT2',
'RIG_PTRX_ROTSTATE',
'RIG_PTRX_STATE',
'RIG_PTT_CM108',
'RIG_PTT_GPIO',
'RIG_PTT_GPION',
'RIG_PTT_NONE',
'RIG_PTT_OFF',
'RIG_PTT_ON',
'RIG_PTT_ON_DATA',
'RIG_PTT_ON_MIC',
'RIG_PTT_PARALLEL',
'RIG_PTT_RIG',
'RIG_PTT_RIG_MICDATA',
'RIG_PTT_SERIAL_DTR',
'RIG_PTT_SERIAL_RTS',
'RIG_RESET_MASTER',
'RIG_RESET_MCALL',
'RIG_RESET_NONE',
'RIG_RESET_SOFT',
'RIG_RESET_VFO',
'RIG_RPT_SHIFT_MINUS',
'RIG_RPT_SHIFT_NONE',
'RIG_RPT_SHIFT_PLUS',
'RIG_SCAN_DELTA',
'RIG_SCAN_MEM',
'RIG_SCAN_NONE',
'RIG_SCAN_PLT',
'RIG_SCAN_PRIO',
'RIG_SCAN_PROG',
'RIG_SCAN_SLCT',
'RIG_SCAN_STOP',
'RIG_SCAN_VFO',
'RIG_SETTING_MAX',
'RIG_SIGNAL_OFF',
'RIG_SIGNAL_ON',
'RIG_SIGNAL_UNSET',
'RIG_SPECTRUM_MODE_CENTER',
'RIG_SPECTRUM_MODE_CENTER_SCROLL',
'RIG_SPECTRUM_MODE_FIXED',
'RIG_SPECTRUM_MODE_FIXED_SCROLL',
'RIG_SPECTRUM_MODE_NONE',
'RIG_SPLIT_OFF',
'RIG_SPLIT_ON',
'RIG_STATUS_ALPHA',
'RIG_STATUS_BETA',
'RIG_STATUS_BUGGY',
'RIG_STATUS_STABLE',
'RIG_STATUS_UNTESTED',
'RIG_TARGETABLE_ALL',
'RIG_TARGETABLE_ANT',
'RIG_TARGETABLE_BAND',
'RIG_TARGETABLE_BANK',
'RIG_TARGETABLE_COMMON',
'RIG_TARGETABLE_FREQ',
'RIG_TARGETABLE_FUNC',
'RIG_TARGETABLE_LEVEL',
'RIG_TARGETABLE_MEM',
'RIG_TARGETABLE_MODE',
'RIG_TARGETABLE_NONE',
'RIG_TARGETABLE_PTT',
'RIG_TARGETABLE_PURE',
'RIG_TARGETABLE_RITXIT',
'RIG_TARGETABLE_ROOFING',
'RIG_TARGETABLE_SPECTRUM',
'RIG_TARGETABLE_TONE',
'RIG_TRN_OFF',
'RIG_TRN_POLL',
'RIG_TRN_RIG',
'RIG_TS_ANY',
'RIG_TYPE_OTHER',
'RIG_VFO_A',
'RIG_VFO_ALL',
'RIG_VFO_B',
'RIG_VFO_C',
'RIG_VFO_CURR',
'RIG_VFO_MAIN',
'RIG_VFO_MAIN_A',
'RIG_VFO_MAIN_B',
'RIG_VFO_MAIN_C',
'RIG_VFO_MEM',
'RIG_VFO_NONE',
'RIG_VFO_OTHER',
'RIG_VFO_RX',
'RIG_VFO_SUB',
'RIG_VFO_SUB_A',
'RIG_VFO_SUB_B',
'RIG_VFO_SUB_C',
'RIG_VFO_TX',
'RIG_VFO_TX_FLAG',
'RIG_VFO_VFO',
'ROT_FLAG_AZIMUTH',
'ROT_FLAG_ELEVATION',
'ROT_FUNC_BIT63',
'ROT_FUNC_NONE',
'ROT_LEVEL_63',
'ROT_LEVEL_FLOAT_LIST',
'ROT_LEVEL_NONE',
'ROT_LEVEL_READONLY_LIST',
'ROT_LEVEL_SPEED',
'ROT_MODEL_AF6SA_WRC',
'ROT_MODEL_ANDROIDSENSOR',
'ROT_MODEL_APEX_SHARED_LOOP',
'ROT_MODEL_ARRAYSOLUTIONS_SAL_12_20_30',
'ROT_MODEL_CNCTRK',
'ROT_MODEL_DCU',
'ROT_MODEL_DUMMY',
'ROT_MODEL_EASYCOMM1',
'ROT_MODEL_EASYCOMM2',
'ROT_MODEL_EASYCOMM3',
'ROT_MODEL_ERC',
'ROT_MODEL_ETHER6',
'ROT_MODEL_F1TETRACKER',
'ROT_MODEL_FLIR',
'ROT_MODEL_FODTRACK',
'ROT_MODEL_GRBLTRK_NET',
'ROT_MODEL_GRBLTRK_SER',
'ROT_MODEL_GS23',
'ROT_MODEL_GS232',
'ROT_MODEL_GS232A',
'ROT_MODEL_GS232A_AZ',
'ROT_MODEL_GS232A_EL',
'ROT_MODEL_GS232B',
'ROT_MODEL_GS232B_AZ',
'ROT_MODEL_GS232B_EL',
'ROT_MODEL_GS232_GENERIC',
'ROT_MODEL_GS23_AZ',
'ROT_MODEL_HD1780',
'ROT_MODEL_IF100',
'ROT_MODEL_INDI',
'ROT_MODEL_IOPTRON',
'ROT_MODEL_LVB',
'ROT_MODEL_MEADE',
'ROT_MODEL_NETROTCTL',
'ROT_MODEL_NEXSTAR',
'ROT_MODEL_NONE',
'ROT_MODEL_PCROTOR',
'ROT_MODEL_PROSISTEL_COMBI_TRACK_AZEL',
'ROT_MODEL_PROSISTEL_D_AZ',
'ROT_MODEL_PROSISTEL_D_EL',
'ROT_MODEL_PROSISTEL_D_EL_CBOXAZ',
'ROT_MODEL_PSTROTATOR',
'ROT_MODEL_RADANT',
'ROT_MODEL_RC2800',
'ROT_MODEL_RC2800_EARLY_AZ',
'ROT_MODEL_RC2800_EARLY_AZEL',
'ROT_MODEL_RCI_AZ',
'ROT_MODEL_RCI_AZEL',
'ROT_MODEL_ROTORCARD',
'ROT_MODEL_ROTOREZ',
'ROT_MODEL_RT21',
'ROT_MODEL_SAEBRTRACK',
'ROT_MODEL_SARTEK1',
'ROT_MODEL_SATEL',
'ROT_MODEL_SATROTCTL',
'ROT_MODEL_SKYWATCHER',
'ROT_MODEL_SPID_MD01_ROT2PROG',
'ROT_MODEL_SPID_ROT1PROG',
'ROT_MODEL_SPID_ROT2PROG',
'ROT_MODEL_ST2',
'ROT_MODEL_TS7400',
'ROT_MODEL_YRC1',
'ROT_MOVE_CCW',
'ROT_MOVE_CW',
'ROT_MOVE_DOWN',
'ROT_MOVE_DOWN_CCW',
'ROT_MOVE_DOWN_CW',
'ROT_MOVE_DOWN_LEFT',
'ROT_MOVE_DOWN_RIGHT',
'ROT_MOVE_LEFT',
'ROT_MOVE_RIGHT',
'ROT_MOVE_UP',
'ROT_MOVE_UP_CCW',
'ROT_MOVE_UP_CW',
'ROT_MOVE_UP_LEFT',
'ROT_MOVE_UP_RIGHT',
'ROT_PARM_FLOAT_LIST',
'ROT_PARM_NONE',
'ROT_PARM_READONLY_LIST',
'ROT_RESET_ALL',
'ROT_SPEED_NOCHANGE',
'ROT_STATUS_BUSY',
'ROT_STATUS_LIMIT_DOWN',
'ROT_STATUS_LIMIT_LEFT',
'ROT_STATUS_LIMIT_RIGHT',
'ROT_STATUS_LIMIT_UP',
'ROT_STATUS_MOVING',
'ROT_STATUS_MOVING_AZ',
'ROT_STATUS_MOVING_DOWN',
'ROT_STATUS_MOVING_EL',
'ROT_STATUS_MOVING_LEFT',
'ROT_STATUS_MOVING_RIGHT',
'ROT_STATUS_MOVING_UP',
'ROT_STATUS_NONE',
'ROT_STATUS_OVERLAP_DOWN',
'ROT_STATUS_OVERLAP_LEFT',
'ROT_STATUS_OVERLAP_RIGHT',
'ROT_STATUS_OVERLAP_UP',
'ROT_TYPE_OTHER',
'TWIDDLE_OFF',
'TWIDDLE_ON',
'VFO_DUAL',
'cvar',
'hamlib_copyright',
'hamlib_version']
        assert expected_properties == self.actual_properties

    @classmethod
    def generate_data(cls, the_object):
        """Extract callables and properties from the given object"""
        callables = []
        properties = []
        for method_or_property in dir(the_object):
            if not method_or_property.startswith("_"):
                if callable(getattr(the_object, method_or_property)):
                    callables.append(method_or_property)
                else:
                    properties.append(method_or_property)

        callables.sort()
        properties.sort()
        return callables, properties
